﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VA.PPMS.IWS.Common
{
    public static class VaHolidays
    {
        public static IList<DateTime> GetHolidays(int year)
        {
            List<DateTime> holidays = new List<DateTime>();

            //New Year's Day 
            holidays.Add(AdjustForWeekendHoliday(new DateTime(year, 1, 1)));

            //Martin Luther King Day -- third monday in January
            holidays.Add(AdjustForMondayHoliday(new DateTime(year, 1, 21)));

            //President's Day -- third monday in February
            holidays.Add(AdjustForMondayHoliday(new DateTime(year, 2, 21)));

            //Memorial Day  -- last monday in May 
            holidays.Add(AdjustForMondayHoliday(new DateTime(year, 5, 31)));

            //Independence Day 
            holidays.Add(AdjustForWeekendHoliday(new DateTime(year, 7, 4)));

            //Labor Day -- 1st Monday in September 
            holidays.Add(AdjustForMondayHoliday(new DateTime(year, 9, 1), 1));

            //Columbus Day -- 2nd monday in October
            holidays.Add(AdjustForMondayHoliday(new DateTime(year, 10, 14)));

            //Veterans Day
            holidays.Add(AdjustForWeekendHoliday(new DateTime(year, 11, 11)));

            //Thanksgiving Day - 4th Thursday in November 
            var thanksgiving = (from day in Enumerable.Range(1, 30)
                                where new DateTime(year, 11, day).DayOfWeek == DayOfWeek.Thursday
                                select day).ElementAt(3);
            DateTime thanksgivingDay = new DateTime(year, 11, thanksgiving);
            holidays.Add(thanksgivingDay.Date);

            //Christmas Day
            holidays.Add(AdjustForWeekendHoliday(new DateTime(year, 12, 25)));

            return holidays;
        }

        public static DateTime AdjustForWeekendHoliday(DateTime holiday)
        {
            if (holiday.DayOfWeek == DayOfWeek.Saturday)
            {
                return holiday.AddDays(-1);
            }
            else if (holiday.DayOfWeek == DayOfWeek.Sunday)
            {
                return holiday.AddDays(1).Date;
            }
            else
            {
                return holiday.Date;
            }
        }

        public static DateTime AdjustForMondayHoliday(DateTime holiday, int increment = -1)
        {
            var dayOfWeek = holiday.DayOfWeek;
            while (dayOfWeek != DayOfWeek.Monday)
            {
                holiday = holiday.AddDays(increment);
                dayOfWeek = holiday.DayOfWeek;
            }
            return holiday.Date;
        }
    }
}
